﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultNetworkPlugin.Controls.Strategy
{
    public interface IDisableIPSourceRoutingStrategy
    {
        void Write(int num);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class DisableIPSourceRoutingDefaultStrategy : ICorrespondenceOS, IDisableIPSourceRoutingStrategy
    {
        public DisableIPSourceRoutingDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,

#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "DisableIPSourceRouting";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion


        public void Write(int num)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"System\CurrentControlSet\Services\Tcpip\Parameters");

            registryKey.SetValue(RegName, num, RegistryValueKind.DWord);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"System\CurrentControlSet\Services\Tcpip\Parameters");

            return new WFRegistry(@"HKEY LOCAL MACHINE\System\CurrentControlSet\Services\Tcpip\Parameters", RegName,
                                  registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.ValueWrite);
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class DisableIPSourceRoutingController
    {
        public DisableIPSourceRoutingController(DisableIPSourceRouting disableIPSourceRouting,
                                                         IDisableIPSourceRoutingStrategy strategy)
        {
            DisableIPSourceRouting = disableIPSourceRouting;
            Strategy = strategy;
        }

        public DisableIPSourceRouting DisableIPSourceRouting { get; set; }
        public IDisableIPSourceRoutingStrategy Strategy { get; set; }

        public void Read()
        {
            DisableIPSourceRouting.SetDisableIPSourceRoutingValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(DisableIPSourceRouting.GetDisableIPSourceRoutingValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
